import QtQuick 2.3

import "../"

import AdaptDemoSystem 1.0

Group {
    property string sceneName: "Group"
    id: blit
    property string textureRT
    property var textureItem

    property vector2d center: Qt.vector2d(0.0, 0.0)
    property vector2d sca: Qt.vector2d(1.0, 1.0)

    property bool flip: true

    property string blendMode: "normal"
    
    Texture {
        textureUnit: 0
        textureRT: blit.textureRT
        textureItem: blit.textureItem
    }
    Shader {
        file: "drawRtPos"
    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
        ShaderParam { paramName: "flip"; paramValue: blit.flip ? 1.0 : 0.0 }
        ShaderParam { paramName: "centerScale"; paramValueVec4: center.x+","+center.y+","+sca.x+","+sca.y }
        blendMode: blit.blendMode
    }

}

